package ru.yandex.intranet.d.web.model;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * User DTO
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Schema(description = "User.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserDto {
    @Nullable
    private final String passportUid;
    @Nullable
    private final String passportLogin;
    private final String firstName;
    private final String lastName;
    private final String gender;

    @JsonCreator
    public UserDto(@Nullable @JsonProperty("passportUid") String passportUid,
                   @Nullable @JsonProperty("passportLogin") String passportLogin,
                   @JsonProperty("firstName") String firstName,
                   @JsonProperty("lastName") String lastName,
                   @JsonProperty("gender") String gender) {
        this.passportUid = passportUid;
        this.passportLogin = passportLogin;
        this.firstName = firstName;
        this.lastName = lastName;
        this.gender = gender;
    }

    @Nullable
    @Schema(description = "Uid.")
    public String getPassportUid() {
        return passportUid;
    }

    @Nullable
    @Schema(description = "Login.")
    public String getPassportLogin() {
        return passportLogin;
    }

    @Schema(description = "First name.", required = true)
    public String getFirstName() {
        return firstName;
    }

    @Schema(description = "Last name.", required = true)
    public String getLastName() {
        return lastName;
    }

    @Schema(description = "Gender.", required = true)
    public String getGender() {
        return gender;
    }
}
