package ru.yandex.intranet.d.web.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonInclude.Include
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Validation message.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 02-12-2021
 */
@Schema(description = "Validation message.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(Include.NON_EMPTY)
data class ValidationMessageDto(
    @get:[Schema(description = "Message level of significance.", required = true)]
    val level: ValidationMessageLevelDto,

    @get:[Schema(description = "Messages content.", required = true)]
    val message: String
)
