package ru.yandex.intranet.d.web.model

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonInclude.Include
import io.swagger.v3.oas.annotations.media.Schema

/**
 * ValidationMassagesDto.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 02-12-2021
 */
@Schema(description = "Business rules validation messages with various levels of significance.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(Include.NON_EMPTY)
data class ValidationMessagesDto @JsonCreator constructor(
    @get:[Schema(description = "Validation messages per field.", nullable = true)]
    @JsonInclude(Include.NON_EMPTY)
    val fieldMessages: Map<String, Set<ValidationMessageDto>>
)
