package ru.yandex.intranet.d.web.model.accounts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Account operation status DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Account operation status.")
public enum AccountOperationStatusDto {

    IN_PROGRESS,
    SUCCESS;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static AccountOperationStatusDto fromJsonValue(String value) {
        return AccountOperationStatusDto.valueOf(value);
    }

}
