package ru.yandex.intranet.d.web.model.accounts;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import ru.yandex.intranet.d.model.accounts.AccountReserveType;

/**
 * Account reserve type DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Account reserve type.")
public enum AccountReserveTypeDto {

    PROVIDER;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    @Nullable
    public static AccountReserveTypeDto fromJsonValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return AccountReserveTypeDto.valueOf(value);
    }

    @Nullable
    public static AccountReserveTypeDto fromModel(@Nullable AccountReserveType model) {
        if (model == null) {
            return null;
        }
        return switch (model) {
            case PROVIDER -> AccountReserveTypeDto.PROVIDER;
        };
    }

    public static ru.yandex.intranet.d.backend.service.proto.AccountReserveType toProto(
            @Nullable AccountReserveType value) {
        if (value == null) {
            return ru.yandex.intranet.d.backend.service.proto.AccountReserveType.RESERVE_TYPE_NONE;
        }
        return switch (value) {
            case PROVIDER -> ru.yandex.intranet.d.backend.service.proto.AccountReserveType.RESERVE_TYPE_PROVIDER;
        };
    }

}
