package ru.yandex.intranet.d.web.model.accounts;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import ru.yandex.intranet.d.model.accounts.AccountReserveType;

/**
 * Account reserve type input DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Account reserve type.")
public enum AccountReserveTypeInputDto {

    UNKNOWN,
    PROVIDER;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    @Nullable
    public static AccountReserveTypeInputDto fromJsonValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return AccountReserveTypeInputDto.valueOf(value);
        } catch (IllegalArgumentException e) {
            return AccountReserveTypeInputDto.UNKNOWN;
        }
    }

    @Nullable
    public static AccountReserveTypeInputDto fromProto(
            @Nullable ru.yandex.intranet.d.backend.service.proto.AccountReserveType value) {
        if (value == null) {
            return null;
        }
        return switch (value) {
            case RESERVE_TYPE_NONE -> null;
            case RESERVE_TYPE_PROVIDER -> AccountReserveTypeInputDto.PROVIDER;
            case UNRECOGNIZED -> AccountReserveTypeInputDto.UNKNOWN;
        };
    }

    @Nullable
    public static AccountReserveType toModel(@Nullable AccountReserveTypeInputDto value) {
        if (value == null) {
            return null;
        }
        return switch (value) {
            case PROVIDER -> AccountReserveType.PROVIDER;
            case UNKNOWN -> throw new IllegalArgumentException("Unexpected account reserve type " + value);
        };
    }

}
