package ru.yandex.intranet.d.web.model.accounts;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Accounts with quota.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Schema(description = "Accounts with quota.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class AccountsWithQuotaDto {
    private final List<AccountWithQuotaDto> accountWithQuotaDtoList;

    @JsonCreator
    public AccountsWithQuotaDto(List<AccountWithQuotaDto> accountWithQuotaDtoList) {
        this.accountWithQuotaDtoList = accountWithQuotaDtoList;
    }

    @Schema(description = "Accounts with quota.")
    public List<AccountWithQuotaDto> getAccountWithQuotaDtoList() {
        return accountWithQuotaDtoList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsWithQuotaDto that = (AccountsWithQuotaDto) o;
        return Objects.equals(accountWithQuotaDtoList, that.accountWithQuotaDtoList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountWithQuotaDtoList);
    }

    @Override
    public String toString() {
        return "AccountsWithQuotaDto{" +
                "accountWithQuotaDtoList=" + accountWithQuotaDtoList +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<AccountWithQuotaDto> accountWithQuotaDtoList = new ArrayList<>();

        public Builder accountWithQuotaDtoList(List<AccountWithQuotaDto> accountWithQuotaDtoList) {
            this.accountWithQuotaDtoList = accountWithQuotaDtoList;
            return this;
        }

        public Builder accountWithQuotaDto(AccountWithQuotaDto accountWithQuotaDto) {
            accountWithQuotaDtoList.add(accountWithQuotaDto);
            return this;
        }

        public AccountsWithQuotaDto build() {
            return new AccountsWithQuotaDto(accountWithQuotaDtoList);
        }
    }
}
