package ru.yandex.intranet.d.web.model.accounts

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Put account DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Account update parameters")
@JsonIgnoreProperties(ignoreUnknown = true)
data class PutAccountDto @JsonCreator constructor(
    @get:Schema(description = "Reserve type.")
    val reserveType: AccountReserveTypeInputDto?,
    @get:Schema(description = "Current account version.")
    val version: Long?
)
