package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.web.model.AmountDto

/**
 * Aggregate amounts DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Aggregate amounts.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class AggregateAmountsDto @JsonCreator constructor(
    @get:Schema(description = "Quota.")
    val quota: AmountDto?,
    @get:Schema(description = "Balance.")
    val balance: AmountDto?,
    @get:Schema(description = "Allocated.")
    val allocated: AmountDto?,
    @get:Schema(description = "Provided.")
    val provided: AmountDto?,
    @get:Schema(description = "Unallocated.")
    val unallocated: AmountDto?,
    @get:Schema(description = "Transferable.")
    val transferable: AmountDto?
)
