package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import java.time.Instant

/**
 * Aggregate for resource DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Aggregate for resource.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class AggregateForResourceDto @JsonCreator constructor(
    @get:Schema(description = "Resource id.", required = true)
    val resourceId: String,
    @get:Schema(description = "Resource name.", required = true)
    val resourceName: String,
    @get:Schema(description = "Segmentation and segment pairs list.", required = true)
    val segmentations: List<AggregateResourceSegmentDto>,
    @get:Schema(description = "Free provision aggregation mode.", required = true)
    val freeProvisionAggregationMode: FreeProvisionAggregationModeDto,
    @get:Schema(description = "Resource usage mode.", required = true)
    val usageMode: ResourceUsageModeDto,
    @get:Schema(description = "Aggregated amounts.", required = true)
    val amounts: AggregateAmountsDto,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    @get:Schema(description = "Last updated at.", required = true)
    val lastUpdate: Instant?,
    @get:Schema(description = "Aggregated usage.")
    val usage: AggregatedResourceUsageDto?
)
