package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Aggregate for resource type DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Aggregate for resource type.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class AggregateForResourceTypeDto @JsonCreator constructor(
    @get:Schema(description = "Resource type id.", required = true)
    val resourceTypeId: String,
    @get:Schema(description = "Resource type name.", required = true)
    val resourceTypeName: String,
    @get:Schema(description = "Aggregates per resource list.", required = true)
    val resources: List<AggregateForResourceDto>
)
