package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Aggregate resource segment DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource segmentation and segment pair.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class AggregateResourceSegmentDto @JsonCreator constructor(
    @get:Schema(description = "Segmentation id.", required = true)
    val segmentationId: String,
    @get:Schema(description = "Segmentation name.", required = true)
    val segmentationName: String,
    @get:Schema(description = "Segmentation grouping order.", required = true)
    val groupingOrder: Long,
    @get:Schema(description = "Segment id.", required = true)
    val segmentId: String,
    @get:Schema(description = "Segment name.", required = true)
    val segmentName: String,
    @get:Schema(description = "'Uncommon' segment flag.", required = true)
    val segmentUncommon: Boolean
)
