package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.web.model.AmountDto
import java.time.Instant

/**
 * Usage for resource DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Usage for resource.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class AggregatedResourceUsageDto @JsonCreator constructor(
    @get:Schema(description = "Resource usage mode.", required = true)
    val mode: ResourceUsageModeDto,
    @get:Schema(description = "Regular plain value.")
    val value: AmountDto?,
    @get:Schema(description = "Average value.")
    val average: AmountDto?,
    @get:Schema(description = "Min value.")
    val min: AmountDto?,
    @get:Schema(description = "Max value.")
    val max: AmountDto?,
    @get:Schema(description = "Median value.")
    val median: AmountDto?,
    @get:Schema(description = "Standard deviation value.")
    val stdev: AmountDto?,
    @get:Schema(description = "Relative accumulated usage value, percents.")
    val relativeUsage: Double?,
    @get:Schema(description = "Variation coefficient value, percents.")
    val kv: Double?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    @get:Schema(description = "Last updated at.")
    val lastUpdate: Instant?,
    @get:Schema(description = "Unused amount estimation.")
    val unusedEstimation: AmountDto?,
    @get:Schema(description = "Underutilized amount estimation.")
    val underutilizedEstimation: AmountDto?
)
