package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.ProviderId
import ru.yandex.intranet.d.kotlin.ResourceTypeId
import ru.yandex.intranet.d.kotlin.SegmentId
import ru.yandex.intranet.d.kotlin.SegmentationId

@Schema(description = "Expanded filter DTO for more complicated resource filtration.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FindServiceTotalsExpandedFilterDto(
    @get:Schema(description = "List of single expanded filters. Conditions are applied by 'OR' statement.")
    val filters: Set<FindServiceTotalsSingleExpandedFilterDto?>?
)

@Schema(description = "DTO describes one row of expanded filter. Conditions are applied by 'AND' statement.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FindServiceTotalsSingleExpandedFilterDto(
    @get:Schema(description = "Provider`s id.")
    val providerId: ProviderId?,
    @get:Schema(description = "Allowed segmentation and segment ids.")
    val segments: Set<SegmentationAndSegmentsIdsDto?>?,
    @get:Schema(description = "Allowed resource types` ids.")
    val resourceTypeIds: Set<ResourceTypeId?>?
)

@Schema(description = "Allowed segmentation and segments` ids.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class SegmentationAndSegmentsIdsDto(
    @get:Schema(description = "Segmentation id.")
    val segmentationId: SegmentationId?,
    @get:Schema(description = "Allowed segments` ids in the segmentation.")
    val segmentIds: Set<SegmentId?>?
)
