package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Find service totals request DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Find service totals request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FindServiceTotalsRequestDto @JsonCreator constructor(
    @get:Schema(description = "Root service id.", required = true)
    val rootServiceId: Long?,
    @get:Schema(description = "Filter.")
    val filter: FindServiceTotalsRequestFilterDto?,
    @get:Schema(description = "Expanded filter.")
    val expandedFilter: FindServiceTotalsExpandedFilterDto? = null
)
