package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Find service totals request filter DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Find service totals request filter.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FindServiceTotalsRequestFilterDto @JsonCreator constructor(
    @get:Schema(description = "Provider id.", required = true)
    val providerId: String?,
    @get:Schema(description = "Segments.")
    val segments: List<FindServiceTotalsRequestFilterSegmentDto?>?
)
