package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Find service totals request filter segment DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Find service totals request filter segment.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FindServiceTotalsRequestFilterSegmentDto @JsonCreator constructor(
    @get:Schema(description = "Segmentation id.", required = true)
    val segmentationId: String?,
    @get:Schema(description = "Segment id.", required = true)
    val segmentId: String?
)
