package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Find subtree total aggregate DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Subtree total aggregate.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FindSubtreeTotalAggregateDto @JsonCreator constructor(
    @get:Schema(description = "Service id.", required = true)
    val serviceId: Long,
    @get:Schema(description = "Service name.", required = true)
    val serviceName: String,
    @get:Schema(description = "Service slug.", required = true)
    val serviceSlug: String,
    @get:Schema(description = "Aggregates per provider list.", required = true)
    val providers: List<AggregateForProviderDto>
)
