package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Find subtree total request DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Find subtree total request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FindSubtreeTotalRequestDto @JsonCreator constructor(
    @get:Schema(description = "Root service id.", required = true)
    val rootServiceId: Long?,
    @get:Schema(description = "Resource id.", required = true)
    val resourceId: String?,
    @get:Schema(description = "Unit id for human-readable amounts, optional.")
    val unitId: String?
)
