package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Get resource selection tree request.
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@Schema(description = "Get resource selection tree request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class GetResourceSelectionDto @JsonCreator constructor(
    @get:Schema(description = "Root service id.", required = true)
    val rootServiceId: Long?,
    @get:Schema(description = "Provider id.", required = true)
    val providerId: String?,
)
