package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Rank subtree amounts aggregate folder DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Folder id and name.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class RankSubtreeAmountsAggregateFolderDto @JsonCreator constructor(
    @get:Schema(description = "Folder id.", required = true)
    val id: String,
    @get:Schema(description = "Folder name.", required = true)
    val name: String
)
