package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Rank subtree amounts request DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Rank subtree amounts request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class RankSubtreeAmountsRequestDto @JsonCreator constructor(
    @get:Schema(description = "Root service id.", required = true)
    val rootServiceId: Long?,
    @get:Schema(description = "Resource id.", required = true)
    val resourceId: String?,
    @get:Schema(description = "Pagination continuation token.")
    val from: String?,
    @get:Schema(description = "Page size limit.")
    val limit: Long?,
    @get:Schema(description = "Sorting parameters.")
    val sortingParams: RankSubtreeSortingParamsDto?,
    @get:Schema(description = "Unit id for human-readable amounts, optional.")
    val unitId: String?
)
