package ru.yandex.intranet.d.web.model.aggregation

data class RankSubtreeSortingParamsDto(
    val field: RankSubtreeSortingField,
    val order: RankSubtreeSortingOrder
) {
    companion object {
        private val defaultParams = RankSubtreeSortingParamsDto(
            RankSubtreeSortingField.TRANSFERABLE,
            RankSubtreeSortingOrder.DESC
        )

        fun default() = defaultParams
    }
}

enum class RankSubtreeSortingOrder(val sortingOrder: String) {
    ASC("ASC"),
    DESC("DESC")
}

enum class RankSubtreeSortingField(val sortingField:String) {
    TRANSFERABLE("transferable"),
    BALANCE("balance"),
    UNALLOCATED("unallocated"),
    ALLOCATED("allocated"),
    PROVIDED("provided"),
    QUOTA("quota"),
    UNUSED_ESTIMATION("unusedEst"),
    UNDERUTILIZED_ESTIMATION("underutilizedEst");
}
