package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Resource usage mode DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource usage mode.")
enum class ResourceUsageModeDto {
    UNDEFINED,
    TIME_SERIES,
    UNUSED_ESTIMATION_VALUE;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): ResourceUsageModeDto? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }
}
