package ru.yandex.intranet.d.web.model.aggregation

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Service aggregate for provider DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Aggregate for provider.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class ServiceAggregateForProviderDto(
    @get:Schema(description = "Provider id.", required = true)
    val providerId: String,
    @get:Schema(description = "Provider name.", required = true)
    val providerName: String,
    @get:Schema(description = "Aggregates per resource type list.", required = true)
    val resourceTypes: List<ServiceAggregateForResourceTypeDto>
)
