package ru.yandex.intranet.d.web.model.aggregation.api

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Aggregate amounts public API DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Aggregate amount.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class AggregateAmountApiDto @JsonCreator constructor(
    @get:Schema(description = "Amount as string.")
    val amount: String,
    @get:Schema(description = "Unit key.")
    val unitKey: String
)
