package ru.yandex.intranet.d.web.model.aggregation.api

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Aggregate amounts public API DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Aggregate amounts.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class AggregateAmountsApiDto @JsonCreator constructor(
    @get:Schema(description = "Quota.")
    val quota: AggregateAmountApiDto?,
    @get:Schema(description = "Balance.")
    val balance: AggregateAmountApiDto?,
    @get:Schema(description = "Provided.")
    val provided: AggregateAmountApiDto?,
    @get:Schema(description = "Allocated.")
    val allocated: AggregateAmountApiDto?,
    @get:Schema(description = "Unallocated.")
    val unallocated: AggregateAmountApiDto?,
    @get:Schema(description = "Transferable.")
    val transferable: AggregateAmountApiDto?
)
