package ru.yandex.intranet.d.web.model.aggregation.api

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import java.time.Instant

/**
 * Aggregate usage public API DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Aggregate usage.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class AggregateUsageApiDto @JsonCreator constructor(
    @get:Schema(description = "Regular plain value.")
    val value: AggregateAmountApiDto?,
    @get:Schema(description = "Average value.")
    val average: AggregateAmountApiDto?,
    @get:Schema(description = "Min value.")
    val min: AggregateAmountApiDto?,
    @get:Schema(description = "Max value.")
    val max: AggregateAmountApiDto?,
    @get:Schema(description = "Median value.")
    val median: AggregateAmountApiDto?,
    @get:Schema(description = "Standard deviation value.")
    val stdev: AggregateAmountApiDto?,
    @get:Schema(description = "Relative accumulated usage value, percents.")
    val relativeUsage: Double?,
    @get:Schema(description = "Variation coefficient value, percents.")
    val kv: Double?,
    @get:Schema(description = "Histogram.")
    val histogram: List<HistogramBinApiDto>?,
    @get:Schema(description = "Time series.")
    val timeSeries: List<TimeSeriesPointApiDto>?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    @get:Schema(description = "Last updated at.")
    val lastUpdate: Instant?,
    @get:Schema(description = "Unused amount estimation.")
    val unusedEstimation: AggregateAmountApiDto?,
    @get:Schema(description = "Underutilized amount estimation.")
    val underutilizedEstimation: AggregateAmountApiDto?
)
