package ru.yandex.intranet.d.web.model.aggregation.api

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Find subtree total public API request DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Find subtree total request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FindSubtreeTotalApiRequestDto @JsonCreator constructor(
    @get:Schema(description = "Root service id.", required = true)
    val rootServiceId: Long?,
    @get:Schema(description = "Resource id.", required = true)
    val resourceId: String?,
    @get:Schema(description = "Provider id.", required = true)
    val providerId: String?,
    @get:Schema(description = "'Include usage' flag.")
    val includeUsage: Boolean?,
    @get:Schema(description = "'Include usage raw' flag.")
    val includeUsageRaw: Boolean?

)
