package ru.yandex.intranet.d.web.model.aggregation.api

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Histogram bin public API DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Histogram bin.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class HistogramBinApiDto @JsonCreator constructor(
    @get:Schema(description = "From.", required = true)
    val from: AggregateAmountApiDto,
    @get:Schema(description = "To.", required = true)
    val to: AggregateAmountApiDto,
    @get:Schema(description = "Value.", required = true)
    val value: Double
)
