package ru.yandex.intranet.d.web.model.aggregation.api

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import java.time.Instant

/**
 * Rank subtree amounts aggregate public API DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Ranked subtree amounts aggregate.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class RankSubtreeAmountsAggregateApiDto(
    @get:Schema(description = "Service id.", required = true)
    val serviceId: Long,
    @get:Schema(description = "Aggregated amounts.", required = true)
    val amounts: AggregateAmountsApiDto,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    @get:Schema(description = "Last updated at.", required = true)
    val lastUpdate: Instant?,
    @get:Schema(description = "Aggregated usage.")
    val usage: AggregateUsageApiDto?
)
