package ru.yandex.intranet.d.web.model.aggregation.api

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.web.model.aggregation.RankSubtreeSortingParamsDto

/**
 * Rank subtree amounts public API request DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Rank subtree amounts request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class RankSubtreeAmountsApiRequestDto @JsonCreator constructor(
    @get:Schema(description = "Root service id.", required = true)
    val rootServiceId: Long?,
    @get:Schema(description = "Resource id.", required = true)
    val resourceId: String?,
    @get:Schema(description = "Provider id.", required = true)
    val providerId: String?,
    @get:Schema(description = "Pagination continuation token.")
    val from: String?,
    @get:Schema(description = "Page size limit.")
    val limit: Long?,
    @get:Schema(description = "Sorting parameters.")
    val sortingParams: RankSubtreeSortingParamsDto?,
    @get:Schema(description = "'Include usage' flag.")
    val includeUsage: Boolean?,
    @get:Schema(description = "'Include usage raw' flag.")
    val includeUsageRaw: Boolean?
)
