package ru.yandex.intranet.d.web.model.aggregation.api

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Rank subtree amounts public API response DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Rank subtree amounts response.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class RankSubtreeAmountsApiResponseDto @JsonCreator constructor(
    @get:Schema(description = "Ranked aggregates list.", required = true)
    val aggregates: List<RankSubtreeAmountsAggregateApiDto>,
    @get:Schema(description = "Next page token.")
    val nextPageToken: String?
)
