package ru.yandex.intranet.d.web.model.aggregation.api

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import java.time.Instant

/**
 * Time series point public API DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Time series point.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class TimeSeriesPointApiDto @JsonCreator constructor(
    @get:Schema(description = "X value.", required = true)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    val x: Instant,
    @get:Schema(description = "Y value.", required = true)
    val y: AggregateAmountApiDto
)
