package ru.yandex.intranet.d.web.model.coordination;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Cluster node DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Cluster node state.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ClusterNodeDto {

    private final String uuid;
    private final String transientFqdn;
    private final String persistentFqdn;
    private final List<String> hostIps;
    private final String version;

    @JsonCreator
    public ClusterNodeDto(@JsonProperty("uuid") String uuid,
                          @JsonProperty("transientFqdn") String transientFqdn,
                          @JsonProperty("persistentFqdn") String persistentFqdn,
                          @JsonProperty("hostIps") List<String> hostIps,
                          @JsonProperty("version") String version) {
        this.uuid = uuid;
        this.transientFqdn = transientFqdn;
        this.persistentFqdn = persistentFqdn;
        this.hostIps = hostIps;
        this.version = version;
    }

    @Schema(description = "Instance unique id.", required = true)
    public String getUuid() {
        return uuid;
    }

    @Schema(description = "Node transient FQDN.", required = true)
    public String getTransientFqdn() {
        return transientFqdn;
    }

    @Schema(description = "Node persistent FQDN.", required = true)
    public String getPersistentFqdn() {
        return persistentFqdn;
    }

    @Schema(description = "Host IPs (likely IPv6 with first for backbone and second for fastbone).", required = true)
    public List<String> getHostIps() {
        return hostIps;
    }

    @Schema(description = "Service version.", required = true)
    public String getVersion() {
        return version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClusterNodeDto that = (ClusterNodeDto) o;
        return Objects.equals(uuid, that.uuid) &&
                Objects.equals(transientFqdn, that.transientFqdn) &&
                Objects.equals(persistentFqdn, that.persistentFqdn) &&
                Objects.equals(hostIps, that.hostIps) &&
                Objects.equals(version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uuid, transientFqdn, persistentFqdn, hostIps, version);
    }

    @Override
    public String toString() {
        return "ClusterNodeDto{" +
                "uuid='" + uuid + '\'' +
                ", transientFqdn='" + transientFqdn + '\'' +
                ", persistentFqdn='" + persistentFqdn + '\'' +
                ", hostIps=" + hostIps +
                ", version='" + version + '\'' +
                '}';
    }

}
