package ru.yandex.intranet.d.web.model.delivery;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Deliverable delta DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Deliverable delta.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeliverableDeltaDto {

    private final Long amount;
    private final String unitKey;

    @JsonCreator
    public DeliverableDeltaDto(Long amount, String unitKey) {
        this.amount = amount;
        this.unitKey = unitKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Amount.", required = true)
    public Optional<Long> getAmount() {
        return Optional.ofNullable(amount);
    }

    @Schema(description = "Unit key.", required = true)
    public Optional<String> getUnitKey() {
        return Optional.ofNullable(unitKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverableDeltaDto that = (DeliverableDeltaDto) o;
        return Objects.equals(amount, that.amount) &&
                Objects.equals(unitKey, that.unitKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, unitKey);
    }

    @Override
    public String toString() {
        return "DeliverableDeltaDto{" +
                "amount=" + amount +
                ", unitKey='" + unitKey + '\'' +
                '}';
    }

    public static final class Builder {

        private Long amount;
        private String unitKey;

        private Builder() {
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder unitKey(String unitKey) {
            this.unitKey = unitKey;
            return this;
        }

        public DeliverableDeltaDto build() {
            return new DeliverableDeltaDto(amount, unitKey);
        }

    }

}
