package ru.yandex.intranet.d.web.model.delivery;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Deliverable metadata request DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Deliverable metadata request.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeliverableMetaRequestDto {

    private final Long quotaRequestId;
    private final Long campaignId;
    private final Long bigOrderId;

    @JsonCreator
    public DeliverableMetaRequestDto(Long quotaRequestId, Long campaignId, Long bigOrderId) {
        this.quotaRequestId = quotaRequestId;
        this.campaignId = campaignId;
        this.bigOrderId = bigOrderId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Quota request id.", required = true)
    public Optional<Long> getQuotaRequestId() {
        return Optional.ofNullable(quotaRequestId);
    }

    @Schema(description = "Campaign id.", required = true)
    public Optional<Long> getCampaignId() {
        return Optional.ofNullable(campaignId);
    }

    @Schema(description = "Big order id.", required = true)
    public Optional<Long> getBigOrderId() {
        return Optional.ofNullable(bigOrderId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverableMetaRequestDto that = (DeliverableMetaRequestDto) o;
        return Objects.equals(quotaRequestId, that.quotaRequestId) &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(bigOrderId, that.bigOrderId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotaRequestId, campaignId, bigOrderId);
    }

    @Override
    public String toString() {
        return "DeliverableMetaRequestDto{" +
                "quotaRequestId=" + quotaRequestId +
                ", campaignId=" + campaignId +
                ", bigOrderId=" + bigOrderId +
                '}';
    }

    public static final class Builder {

        private Long quotaRequestId;
        private Long campaignId;
        private Long bigOrderId;

        private Builder() {
        }

        public Builder quotaRequestId(Long quotaRequestId) {
            this.quotaRequestId = quotaRequestId;
            return this;
        }

        public Builder campaignId(Long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder bigOrderId(Long bigOrderId) {
            this.bigOrderId = bigOrderId;
            return this;
        }

        public DeliverableMetaRequestDto build() {
            return new DeliverableMetaRequestDto(quotaRequestId, campaignId, bigOrderId);
        }

    }

}
