package ru.yandex.intranet.d.web.model.delivery;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Deliverable metadata response DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Deliverable metadata response.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeliverableMetaResponseDto {

    private final long quotaRequestId;
    private final long campaignId;
    private final long bigOrderId;

    @JsonCreator
    public DeliverableMetaResponseDto(long quotaRequestId, long campaignId, long bigOrderId) {
        this.quotaRequestId = quotaRequestId;
        this.campaignId = campaignId;
        this.bigOrderId = bigOrderId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Quota request id.", required = true)
    public long getQuotaRequestId() {
        return quotaRequestId;
    }

    @Schema(description = "Campaign id.", required = true)
    public long getCampaignId() {
        return campaignId;
    }

    @Schema(description = "Big order id.", required = true)
    public long getBigOrderId() {
        return bigOrderId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverableMetaResponseDto that = (DeliverableMetaResponseDto) o;
        return quotaRequestId == that.quotaRequestId &&
                campaignId == that.campaignId &&
                bigOrderId == that.bigOrderId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotaRequestId, campaignId, bigOrderId);
    }

    @Override
    public String toString() {
        return "DeliverableMetaResponseDto{" +
                "quotaRequestId=" + quotaRequestId +
                ", campaignId=" + campaignId +
                ", bigOrderId=" + bigOrderId +
                '}';
    }

    public static final class Builder {

        private Long quotaRequestId;
        private Long campaignId;
        private Long bigOrderId;

        private Builder() {
        }

        public Builder setQuotaRequestId(long quotaRequestId) {
            this.quotaRequestId = quotaRequestId;
            return this;
        }

        public Builder setCampaignId(long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setBigOrderId(long bigOrderId) {
            this.bigOrderId = bigOrderId;
            return this;
        }

        public DeliverableMetaResponseDto build() {
            Preconditions.checkNotNull(quotaRequestId, "QuotaRequestId is required");
            Preconditions.checkNotNull(campaignId, "CampaignId is required");
            Preconditions.checkNotNull(bigOrderId, "BigOrderId is required");
            return new DeliverableMetaResponseDto(quotaRequestId, campaignId, bigOrderId);
        }

    }

}
