package ru.yandex.intranet.d.web.model.delivery

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Delivery account DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Delivery account.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryAccountDto @JsonCreator constructor(
    @get:Schema(description = "Account id.", required = true)
    val id: String,
    @get:Schema(description = "External account id.", required = true)
    val externalId: String,
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @get:Schema(description = "External account key.")
    val externalKey: String?,
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @get:Schema(description = "Account display name.")
    val displayName: String?,
    @get:Schema(description = "Folder id.", required = true)
    val folderId: String,
    @get:Schema(description = "Folder name.", required = true)
    val folderName: String
)
