package ru.yandex.intranet.d.web.model.delivery

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Delivery accounts space DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Delivery accounts space.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryAccountsSpaceDto @JsonCreator constructor(
    @get:Schema(description = "Accounts space id.", required = true)
    val id: String,
    @get:Schema(description = "Accounts space name.", required = true)
    val name: String,
    @get:Schema(description = "Accounts space key.", required = true)
    val key: String,
    @get:Schema(description = "'Is eligible for delivery' flag.", required = true)
    val eligible: Boolean,
    @get:Schema(description = "Ineligibility reasons.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    val ineligibilityReasons: Set<String>?,
    @get:Schema(description = "Resources and accounts.", required = true)
    val resourcesAccounts: DeliveryResourcesAccountsDto
)
