package ru.yandex.intranet.d.web.model.delivery

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Delivery destination DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Delivery destination request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryDestinationDto @JsonCreator constructor(
    @get:Schema(description = "Service id.", required = true)
    val serviceId: Long?,
    @get:Schema(description = "Quota request id.", required = true)
    val quotaRequestId: Long?,
    @get:Schema(description = "Resource ids.", required = true)
    val resourceIds: List<String?>?
)
