package ru.yandex.intranet.d.web.model.delivery

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Delivery destination DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Delivery destination providers.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryDestinationProvidersDto @JsonCreator constructor(
    @get:Schema(description = "Service id.", required = true)
    val serviceId: Long,
    @get:Schema(description = "Quota request id.", required = true)
    val quotaRequestId: Long,
    @get:Schema(description = "'Is eligible for delivery' flag.", required = true)
    val eligible: Boolean,
    @get:Schema(description = "Ineligibility reasons.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    val ineligibilityReasons: Set<String>?,
    @get:Schema(description = "Providers.", required = true)
    val providers: Set<DeliveryProviderDto>
)
