package ru.yandex.intranet.d.web.model.delivery

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Delivery destination request DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Delivery destination request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryDestinationRequestDto @JsonCreator constructor(
    @get:Schema(description = "User uid.", required = true)
    val userUid: String?,
    @get:Schema(description = "Delivery destinations", required = true)
    val deliverables: List<DeliveryDestinationDto?>?
)
