package ru.yandex.intranet.d.web.model.delivery

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Delivery destination resource DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Delivery destination resource.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryDestinationResourceDto @JsonCreator constructor(
    @get:Schema(description = "Resource id.", required = true)
    val id: String,
    @get:Schema(description = "Resource key.", required = true)
    val key: String,
    @get:Schema(description = "Resource name.", required = true)
    val name: String,
    @get:Schema(description = "'Is eligible for delivery' flag.", required = true)
    val eligible: Boolean,
    @get:Schema(description = "Ineligibility reasons.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    val ineligibilityReasons: Set<String>?
)
