package ru.yandex.intranet.d.web.model.delivery

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Delivery destination response DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Delivery destination response.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryDestinationResponseDto @JsonCreator constructor(
    @get:Schema(description = "Destinations.", required = true)
    val destinations: Set<DeliveryDestinationProvidersDto>,
    @get:Schema(description = "Resources.", required = true)
    val resources: Set<DeliveryDestinationResourceDto>
)
