package ru.yandex.intranet.d.web.model.delivery

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Delivery provider DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Delivery provider.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryProviderDto @JsonCreator constructor(
    @get:Schema(description = "Provider id.", required = true)
    val id: String,
    @get:Schema(description = "Provider name.", required = true)
    val name: String,
    @get:Schema(description = "Provider key.", required = true)
    val key: String,
    @get:Schema(description = "'Is eligible for delivery' flag.", required = true)
    val eligible: Boolean,
    @get:Schema(description = "Ineligibility reasons.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    val ineligibilityReasons: Set<String>?,
    @get:Schema(description = "Accounts spaces.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    val accountsSpaces: Set<DeliveryAccountsSpaceDto>?,
    @get:Schema(description = "Resources and accounts.", required = true)
    val resourcesAccounts: DeliveryResourcesAccountsDto?
)
