package ru.yandex.intranet.d.web.model.delivery

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Delivery resources accounts DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Delivery accounts and resources.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryResourcesAccountsDto @JsonCreator constructor(
    @get:Schema(description = "Resource ids.", required = true)
    val resourceIds: Set<String>,
    @get:Schema(description = "Accounts.", required = true)
    val accounts: Set<DeliveryAccountDto>
)
