package ru.yandex.intranet.d.web.model.delivery;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Delivery response DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Delivery response.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeliveryResponseDto {

    private final List<DeliverableResponseDto> deliverables;

    @JsonCreator
    public DeliveryResponseDto(List<DeliverableResponseDto> deliverables) {
        this.deliverables = deliverables;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Deliveries.", required = true)
    public List<DeliverableResponseDto> getDeliverables() {
        return deliverables;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryResponseDto that = (DeliveryResponseDto) o;
        return Objects.equals(deliverables, that.deliverables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deliverables);
    }

    @Override
    public String toString() {
        return "DeliveryResponseDto{" +
                "deliverables=" + deliverables +
                '}';
    }

    public static final class Builder {

        private final List<DeliverableResponseDto> deliverables = new ArrayList<>();

        private Builder() {
        }

        public Builder addDeliverable(DeliverableResponseDto deliverable) {
            deliverables.add(deliverable);
            return this;
        }

        public DeliveryResponseDto build() {
            return new DeliveryResponseDto(deliverables);
        }

    }

}
