package ru.yandex.intranet.d.web.model.delivery.provide

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.web.model.delivery.DeliverableDeltaDto
import ru.yandex.intranet.d.web.model.delivery.DeliverableMetaRequestDto
import java.util.*

/**
 * Destination DTO for delivery and provide operation
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Delivery and provide destination request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryAndProvideDestinationDto @JsonCreator constructor(
    @get:Schema(description = "Service id.", required = true)
    val serviceId: Long?,
    @get:Schema(description = "Provider id.", required = true)
    val providerId: String?,
    @get:Schema(description = "Folder id.", required = true)
    val folderId: String?,
    @get:Schema(description = "Account id.", required = true)
    val accountId: String?,
    @get:Schema(description = "Resource id.", required = true)
    val resourceId: String?,
    @get:Schema(description = "Deliverable delta.", required = true)
    val delta: DeliverableDeltaDto?,
    @get:Schema(description = "Deliverable metadata request.", required = true)
    val meta: DeliverableMetaRequestDto?
) {
    fun getServiceIdOptional() = Optional.ofNullable(serviceId)
    fun getProviderIdOptional() = Optional.ofNullable(providerId)
    fun getFolderIdOptional() = Optional.ofNullable(folderId)
    fun getAccountIdOptional() = Optional.ofNullable(accountId)
    fun getResourceIdOptional() = Optional.ofNullable(resourceId)
    fun getDeltaOptional() = Optional.ofNullable(delta)
    fun getMetaOptional() = Optional.ofNullable(meta)

    data class Builder(var serviceId: Long? = null,
                       var providerId: String? = null,
                       var folderId: String? = null,
                       var accountId: String? = null,
                       var resourceId: String? = null,
                       var delta: DeliverableDeltaDto? = null,
                       var meta: DeliverableMetaRequestDto? = null
    ) {
        fun serviceId(serviceId: Long) = apply { this.serviceId = serviceId }
        fun providerId(providerId: String) = apply { this.providerId = providerId }
        fun folderId(folderId: String) = apply { this.folderId = folderId }
        fun accountId(accountId: String) = apply { this.accountId = accountId }
        fun resourceId(resourceId: String) = apply { this.resourceId = resourceId }
        fun delta(delta: DeliverableDeltaDto) = apply { this.delta = delta }
        fun meta(meta: DeliverableMetaRequestDto) = apply { this.meta = meta }
        fun build() = DeliveryAndProvideDestinationDto(serviceId, providerId, folderId, accountId,
            resourceId, delta, meta)
    }
}

