package ru.yandex.intranet.d.web.model.delivery.provide

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Delivery and provide metadata response DTO.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Schema(description = "Delivery and provide metadata response.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryAndProvideMetaResponseDto @JsonCreator constructor(
    @get:Schema(description = "Quota request id.", required = true)
    val quotaRequestId: Long,
    @get:Schema(description = "Campaign id.", required = true)
    val campaignId: Long,
    @get:Schema(description = "Big order ids.", required = true)
    val bigOrderIds: Set<Long>
) {
    data class Builder(
        var quotaRequestId: Long? = null,
        var campaignId: Long? = null,
        val bigOrderIds: MutableSet<Long> = mutableSetOf()
    ) {
        fun quotaRequestId(quotaRequestIdL: Long) = apply { this.quotaRequestId = quotaRequestIdL}
        fun campaignId(campaignId: Long) = apply { this.campaignId = campaignId}
        fun addBigOrderId(bigOrderId: Long) =
            apply { this.bigOrderIds.add(bigOrderId) }
        fun addBigOrderIds(bigOrderIds: Collection<Long>) =
            apply { this.bigOrderIds.addAll(bigOrderIds) }
        fun build() = DeliveryAndProvideMetaResponseDto(quotaRequestId!!, campaignId!!, bigOrderIds.toSet())
    }
}
